﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Navigation;
using Microsoft.Phone.Controls;
using Microsoft.Phone.Shell;
using TSCSample.Resources;
using TSCSDK;
using Windows.Networking.Proximity;
using Windows.Networking.Sockets;
using Windows.Networking;
using Windows.Storage.Streams;
using System.Text;
using System.Threading.Tasks;
using System.IO;
using Windows.Storage;
using System.Net.Sockets;
using System.Threading;
using System.Collections.ObjectModel;



namespace TSCSample
{
    public partial class MainPage : PhoneApplicationPage
    {
        private TSCSDK.Ethernet IP = new TSCSDK.Ethernet();
        private TSCSDK.Bluetooth bluetooth = new TSCSDK.Bluetooth();
        private static byte[] test5 = new byte[1024];
        public ObservableCollection<String> StringsList { get; set; }

        private string[] takefile;
        private int portselect = 0;
        private static string b_mac = "00:19:0E:A0:7A:D5";
        private static string ipaddress = "10.0.10.220";
        public MainPage()
        {
    
            InitializeComponent();
            Bluetooth_Mac.Text = b_mac;
            Ethernet_IP.Text = ipaddress;
            //BuildLocalizedApplicationBar();


        }

        private void Button_Click(object sender, RoutedEventArgs e)
        {
            if (Bluetooth_Mac.Text.Length > 1 && Ethernet_IP.Text.Length == 0)
            {
                portselect = 1;
                b_mac = Bluetooth_Mac.Text;
                bluetooth.openport(Bluetooth_Mac.Text);
          
                
            }
            else if(Ethernet_IP.Text.Length > 1 && Bluetooth_Mac.Text.Length == 0)
            {
                portselect = 2;
                IP.openport(Ethernet_IP.Text,9100);
            }


        }


        private async void Button_Click_1(object sender, RoutedEventArgs e)
        {

            if (portselect == 1)
            {
                bluetooth.sendcommand(commandbox.Text+"\n");
            }
            else if (portselect == 2)
            {
                IP.sendcommand(commandbox.Text + "\n");
            }

            /*
            bluetooth.clearbuffer();
            bluetooth.setup(100, 50, 3, 6, 0, 0, 0);
            bluetooth.barcode(100, 200, "128", 100, 1, 0, 3, 3, "123456789");
            bluetooth.printerfont(100, 100, "3", 0, 1, 1, "Printer Font Test");
            bluetooth.sendcommand("BOX 50,50,500,400,3\n");
            bluetooth.printlabel(1, 1);
            */
            
            //IP.clearbuffer();
            //IP.setup(100, 60, 4, 6, 0, 0, 0);
            //IP.barcode(100, 200, "128", 100, 1, 0, 3, 3, "123456789");
            //IP.printerfont(100, 100, "3", 0, 1, 1, "Printer Font Test");
            //IP.sendcommand("BOX 50,50,500,400,3\n");
            //IP.putpcx(200,100,"UL.PCX");
            //IP.printlabel(1, 1);

        }


        private void Button_Click_2(object sender, RoutedEventArgs e)
        {

            if (portselect == 1)
            {
                bluetooth.closeport();
            }
            else if (portselect == 2)
            {
                IP.closeport();
            }


        }

        private async void longListSelector_SelectionChanged(object sender, SelectionChangedEventArgs e)
        {


            if (portselect == 1)
            {
                string name = longListSelector.SelectedItem.ToString();
                byte[] bluetooth_buffer = await bluetooth.sendcommandandfeedback("RUN " + name + "\n");
                prompt.Text = Encoding.UTF8.GetString(bluetooth_buffer, 0, bluetooth_buffer.Length);
            }
            else if(portselect == 2)
            {
                string name = longListSelector.SelectedItem.ToString();
                byte[] Ethernet_buffer = await IP.sendcommandandfeedback("RUN " + name + "\n");
                prompt.Text = Encoding.UTF8.GetString(Ethernet_buffer, 0, Ethernet_buffer.Length);
            }
        }

        private async void Button_Click_3(object sender, RoutedEventArgs e)
        {

            if (portselect == 1)
            {
                takefile = await bluetooth.filelist();
                StringsList = new ObservableCollection<string>(takefile);
                DataContext = StringsList;
            }
            else if (portselect == 2)
            {
                takefile = await IP.filelist();
                StringsList = new ObservableCollection<string>(takefile);
                DataContext = StringsList;
            }


        }


    }
}